<?php
/**
 * @var string $existingVersion
 */
?>

<?php if ($existingVersion !== 'v2') { ?>
    <br />
    <br />
    <strong>If you have done any CSS customisation with player v1, those will NOT translate to player v2.</strong>
    <p>Please get in touch with us from the "Support" section in your VdoCipher dashboard.</p>
<?php }?>
<details class="vdo_docs">
    <summary>How to choose player version?</summary>
    <div>
        <p>
            The new version of the player is v2. It is the second version of our HTML5 player. There are many improvements to player including
        </p>
        <ul>
            <li>Smaller file size resulting in faster load times</li>
            <li>Improved layout on small screen devices</li>
            <li>Work better with webpage styles</li>
            <li>Improved progress bar function with drag function</li>
            <li>Auto resume from last watched position</li>
            <li>Greater customisation capabilities, chapters, playlists and other features coming soon.</li>
        </ul>
        <p>We will continue to support v1 player without any planned end-of-support. We will continue to make security and maintenance fixes to ensure that v1 plays across browsers as much as possible.</p>
        <p>The looks of v2 is noticeably different, and we wanted to give you the choice in making the transition at your convenience. If you have to choose, we recommend to use player v2 because of all the improvements.</p>
        <p>If you have any questions or feedback or feature suggestions about the new player versions, we love to hear about it. Go to the support section on the sidebar and send us a ticket.</p>
    </div>
</details>
